class TWT_ZombiePawn extends ScriptedPawn;

//Chatty little fellows
#exec AUDIO IMPORT FILE="Sounds\MummyZombie.WAV" NAME="MummyZombie"
#exec AUDIO IMPORT FILE="Sounds\ZombieBackFromDead.WAV" NAME="ZombieBackFromDead"
#exec AUDIO IMPORT FILE="Sounds\ZombieLongDeath.WAV" NAME="ZombieLongDeath"
#exec AUDIO IMPORT FILE="Sounds\ZombieMoan.WAV" NAME="ZombieMoan"
#exec AUDIO IMPORT FILE="Sounds\ZombieRising.WAV" NAME="ZombieRising"

var name WalkAnimName;
var	float	WalkingSpeed;
var	name	NextAnim;
var	float	LastPainTime;
var	bool	bShaking, bResurect;
var	Pawn	OldEnemy;
var	int	PHtmp;

function PreBeginPlay()
{
	SetWalkAnim();
	PreSetMovement();
	Enemy = None;
	bResurect = False;
	SetPhysics(PHYS_Falling);
	Super.PreBeginPlay();
}

function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation,
                                   Vector momentum, name damageType)
{
	if ((instigatedBy != None) && (instigatedBy != Self)) { SetEnemy(instigatedBy); }
	GotoState('TakeHit');
	Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
}

function SetWalkAnim()
{
   local float WalkAnim;

   walkanim = FRand();
   if (walkanim > 0.66)
   {
      walkanimname = 'walkA';
   }
   else	if (walkanim > 0.33)
   {
      walkanimname ='walkcs';
   }
   else
   {
      walkanimname ='walkcri';
   }

      WalkingSpeed=(FRand()*0.55)+0.25;
}

function PreSetMovement()
{
	MaxDesiredSpeed = 0.79 + 0.07 * skill;
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	bCanDoSpecial = false;
}

function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
{
	SeePlayer(shooter);
}

function Bump(actor Other)
{
	if (TWT_ZombiePawn(Other) == None)
	{
		if ((Other == Enemy) || ((Pawn(Other) != None) && SetEnemy(Pawn(Other))))
		{
			if (Pawn(Other).health > 0)
			{
				GotoState('MeleeAttack');
			}
		}
	}
}

function EnemyAcquired()
{
	GotoState('Attacking');
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	return AttitudeTo(Other);
}

function damageAttitudeTo(pawn Other)
{
	if (TWT_ZombiePawn(Other) != None)
		return;
	AttitudeToPlayer = ATTITUDE_Hate;
}

function eAttitude AttitudeTo(Pawn Other)
{
	if (Other.health > 0)
	{
		if(Other.IsA('TWT_ZombiePawn'))
			return ATTITUDE_Friendly;
		else
			return ATTITUDE_Hate;
	}
}

function Trigger(actor Other, pawn EventInstigator)
{
	local Pawn currentEnemy;

	if ((Other == Self) || (Health <= 0) || (EventInstigator == None))
		return;
	if ( EventInstigator.bIsPlayer)
		AttitudeToPlayer = ATTITUDE_Hate;
	else
		Hated = EventInstigator;
	currentEnemy = Enemy;
	SetEnemy(EventInstigator);
	if (Enemy != currentEnemy)
	{	
		PlayAcquisitionSound();
		GotoState('Attacking');
	}
}

function bool NeedToTurn(vector targ)
{
	local int YawErr;

	DesiredRotation = Rotator(targ - location);
	DesiredRotation.Yaw = DesiredRotation.Yaw & 65535;
	YawErr = (DesiredRotation.Yaw - (Rotation.Yaw & 65535)) & 65535;
	if ( (YawErr < 4000) || (YawErr > 61535) )
		return false;
	return true;
}

function bool SetEnemy(Pawn NewEnemy)
{
	if ((Enemy != None) && (NewEnemy != Self) && (Enemy == NewEnemy))
		return true;
	if (Enemy == Self) { Enemy = None; }
	if ((NewEnemy == None) || (NewEnemy == Self) || (NewEnemy.Health <= 0) || (NewEnemy.Location == vect(0,0,0)) || (Spectator(NewEnemy) != None))
	{
		if ((NewEnemy == None) || (NewEnemy == Self)) { Enemy = None; }
		return false;
	}
	if (DeathMatchPlus(Level.Game) != None)
		if (DeathMatchPlus(Level.Game).bGameEnded || (DeathMatchPlus(Level.Game).bRequireReady && (DeathMatchPlus(Level.Game).CountDown > 0)))
			return false;
	Target = NewEnemy;
	return SetEnemy2(NewEnemy);
}

function bool SetEnemy2(Pawn NewEnemy)
{
	local bool result;
	local eAttitude newAttitude, oldAttitude;
	local bool noOldEnemy;
	local float newStrength;

	noOldEnemy = (Enemy == None);
	result = false;
	newAttitude = AttitudeTo(NewEnemy);

	if (!noOldEnemy)
	{
		if (AlarmTag != '')
		{
			OldEnemy = Enemy;
			Enemy = NewEnemy;
			result = true;
		}
		else
		{
			oldAttitude = AttitudeTo(Enemy);
			if ((newAttitude < oldAttitude) ||
					((newAttitude == oldAttitude)
						&& ((VSize(NewEnemy.Location - Location) < VSize(Enemy.Location - Location))
							|| !LineOfSightTo(Enemy))))
			{
				result = true;
				OldEnemy = Enemy;
				Enemy = NewEnemy;
			}
		}
	}
	else if (newAttitude < ATTITUDE_Ignore)
	{
		result = true;
		Enemy = NewEnemy;
	}

 	if (result)
	{
		EnemyAcquired();
	}
	else if (NewAttitude < ATTITUDE_Threaten)
		OldEnemy = NewEnemy;
	return result;
}

function SetMovementPhysics()
{
	if (Region.Zone.bWaterZone && (Physics != PHYS_Swimming))
		{ SetPhysics(PHYS_Swimming); }
	else if (!Region.Zone.bWaterZone && (Physics != PHYS_Falling) && (Physics != PHYS_Walking))
		{ SetPhysics(PHYS_Walking); }
	if (Physics == PHYS_Falling)
		{ bCanJump = false; }
	else
		{ bCanJump = true; }
}

function ZoneChange(ZoneInfo newZone)
{
	local vector jumpDir;

	if ( newZone.bWaterZone )
	{
		if (!bCanSwim)
			MoveTimer = -1.0;
		else if (Physics != PHYS_Swimming)
		{
			if (Physics != PHYS_Falling)
				PlayDive(); 
			setPhysics(PHYS_Swimming);
		}
	}
	else if (Physics == PHYS_Swimming)
	{
		if (bCanWalk && (Abs(Acceleration.X) + Abs(Acceleration.Y) > 0) && CheckWaterJump(jumpDir))
			{ SetPhysics(PHYS_Falling); bCanJump = false; JumpOutOfWater(jumpDir); TakeDamage(0, self, self.location, vect(0,0,0) , ''); }
	}
	bCanJump = (Physics != PHYS_Falling);
}

function PlayAcquisitionSound()
{
  if (FRand() < 0.25)
    {
        PlaySound(sound'ZombieMoan', SLOT_Talk,, true);
        PlaySound(sound'ZombieMoan', SLOT_Misc,, true);
    }
}

function PlayWaitingAmbush()
{
	LoopAnim(WalkAnimName);
}

function TweenToMelee(float tweentime)
{
	TweenAnim('melee', tweentime);
}

function TweenToWalking(float tweentime)
{
	TweenAnim(WalkAnimName, tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenToWalking(tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenToWalking(tweentime);
}

function PlayWalking()
{ 
       local int randm;

       LoopAnim(WalkAnimName,,,);
       if (FRand() < 0.25)
       {
          randm = Rand(5);
          switch(randm)
          {
            case 0:
              PlaySound(sound'MummyZombie', SLOT_Talk,, true);
              PlaySound(sound'MummyZombie', SLOT_Misc,, true);
              break;
            case 1:
              PlaySound(sound'ZombieBackFromDead', SLOT_Talk,, true);
              PlaySound(sound'ZombieBackFromDead', SLOT_Misc,, true);
              break;
            case 2:
              PlaySound(sound'ZombieLongDeath', SLOT_Talk,, true);
              PlaySound(sound'ZombieLongDeath', SLOT_Misc,, true);
              break;
            case 3:
              PlaySound(sound'ZombieMoan', SLOT_Talk,, true);
              PlaySound(sound'ZombieMoan', SLOT_Misc,, true);
              break;
            case 4:
              PlaySound(sound'ZombieRising', SLOT_Talk,, true);
              PlaySound(sound'ZombieRising', SLOT_Misc,, true);
              break;
          }
      }
}

function PlayTurning()
{
	TweenAnim(WalkAnimName, 0.35);
}

function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
{
  if (frand() >0.5)
  	TweenAnim('TakeHit1', tweentime);
  else
  	TweenAnim('TakeHit2', tweentime);
}

function PlayDive()
{
	PlayAnim(WalkAnimName,,0.1);
}

function TweenToFalling()
{
	TweenAnim('Falling', 0.4);
}

function PlayInAir()
{
	TweenAnim('Falling', 0.4);
}

function PlayLanded(float impactVel)
{
	TweenAnim(WalkAnimName, 0.25);
	if (impactVel < -250)
	{
		TakeDamage((impactVel + 125) * -0.10, self, self.location, vect(0,0,0) , 'Splattered');
		if (Velocity.Z < -1.4 * JumpZ)
			MakeNoise(-0.5 * Velocity.Z/(FMax(JumpZ, 150.0)));
	}
	bJustLanded = true;
	GotoState('Attacking');
}

function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	// mutator hook to prevent deaths
	// WARNING - don't prevent bot suicides - they suicide when really needed
	if ( Level.Game.BaseMutator.PreventDeath(self, Killer, damageType, HitLocation) )
	{
		Health = max(Health, 1); //mutator should set this higher
		return;
	}
	if ( bDeleteMe )
		return; //already destroyed
	Health = Min(0, Health);
	level.game.Killed(Killer, self, damageType);
	Velocity.Z *= 1.3;
	if ((Gibbed(DamageType)) || (DamageType == 'Decapitated') || (DamageType == 'Splattered'))
	{
		SpawnGibbedCarcass();
		Destroy();
	}
	if (FRand() > 0.5)
		PlayAnim('deathDecap', 0.7, 0.1);
	else
		PlayAnim('deathShot', 0.7, 0.1);
	PlayDying(DamageType, HitLocation);
	if ( Level.Game.bGameEnded )
		return;
	if ( RemoteRole == ROLE_AutonomousProxy )
		ClientDying(DamageType, HitLocation);
	if (FRand() < 0.08)
	{
		Health = 50;
		Acceleration = vect(0,0,0);
		bResurect = True;
		SetEnemy(Killer);
		GotoState('RiseFromTheDead');
	}
	else
		GotoState('Dying');
}

function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	Enemy = None;
	if ((OldEnemy != None) && (OldEnemy != Self))
	{
		SetEnemy(OldEnemy);
		OldEnemy = None;
	}
	GotoState('Attacking');
}

auto state RiseFromTheDead
{
  ignores seeplayer, hearnoise, bump, hitwall, falling, TakeDamage;

Begin:
	if (!bResurect)
	{
		if (FRand() > 0.5)
			PlayAnim('Rise');
		else
			PlayAnim('Rise2');
	}
	sleep((FRand() * 6.0) + 2.5);
	PlaySound(sound'ZombieBackFromDead', SLOT_Talk,, true);
	PlaySound(sound'ZombieBackFromDead', SLOT_Misc,, true);
	TweenToWalking((FRand() * 2.5) + 0.75);
	FinishAnim();
	GotoState('Attacking');
}

state VictoryDance
{
  ignores seeplayer, hearnoise, bump, hitwall, falling;

	function PlayVictoryDance()
	{
		PlayAnim('VictoryDance');
	}

Begin:
	PlaySound(sound'ZombieRising', SLOT_Talk,, true);
	PlaySound(sound'ZombieRising', SLOT_Misc,, true);
	if (FRand() < 0.0125)
        {
		PlayVictoryDance();
	}
	FinishAnim();
	GotoState('Attacking');
}

state Attacking
{
	function BeginState()
	{
	SetMovementPhysics();
	if ( Physics == PHYS_Falling )
		SetFall();
	}

	function EndState()
	{
	}

	function ChooseAttackMode()
	{
		if (Enemy == None)
		{
			GotoState('Wandering');
		}
		else
		{
			GotoState('Charging');
		}
	}
Begin:
	if ((Enemy != None) && (Enemy == Self)) { Enemy = None; }
	ChooseAttackMode();
}

state MeleeAttack
{
ignores SeePlayer, HearNoise, WarnTarget, Animend, Bump;

	function BeginState()
	{
	}

	function EndState()
	{
	}

	function bool CanShake()
	{
	local TWT_ZombiePawn TWTZ;

		foreach RadiusActors(class'TWT_ZombiePawn', TWTZ, 94, Enemy.Location)
		{
			if (TWTZ.bShaking) { return False; }
		}
		return True;
	}

Begin:
	DesiredRotation = Rotator(Enemy.Location - Location);
	TweenToMelee(0.3);
	FinishAnim();
	LoopAnim('melee');

FaceTarget:
	if ((Enemy == None) || (Enemy == Self)) { FinishAnim(); Enemy = None; GotoState('Attacking'); }
	if (NeedToTurn(Enemy.Location))
	{
	        PlayTurning();
		TurnToward(Enemy);
		TweenToMelee(0.3);
		FinishAnim();
 	  	LoopAnim('melee');
	}
	if ((VSize(Location - Enemy.Location) > MeleeRange + CollisionRadius + Enemy.CollisionRadius) ||
		(abs(Location.Z - Enemy.Location.Z) > 0.8 * (MeleeRange + Enemy.CollisionHeight)))
	{
	        TweenToWalking(0.3);
	       	FinishAnim();
		GotoState('Attacking');
	}
	if ((PlayerPawn(Enemy) != None) && CanShake())
		{ GotoState('ShakingPlayer'); }
	else
		{ if (PlayerPawn(Enemy) == None) { GotoState('ShakingPlayer'); } }
	Sleep(1);
	if ((VSize(Location - Enemy.Location) > MeleeRange + CollisionRadius + Enemy.CollisionRadius) ||
		(abs(Location.Z - Enemy.Location.Z) > 0.8 * (MeleeRange + Enemy.CollisionHeight)))
	{
	        TweenToWalking(0.3);
	       	FinishAnim();
		GotoState('Attacking');
	}
	GotoState ('MeleeAttack','FaceTarget');
}

state ShakingPlayer
{
	ignores SeePlayer ,HearNoise, WarnTarget, Animend, Bump;

	function BeginState()
	{
		PlaySound(sound'ZombieLongDeath', SLOT_Talk,,true);
		PlaySound(sound'ZombieLongDeath', SLOT_Interact,,true);
	}

 	function EndState()
	{
		if ((Enemy != None) && (bShaking))
  		{
			Enemy.SetPhysics(PHYS_Falling);
			if (PlayerPawn(Enemy) != None)
			{
				PlayerPawn(Enemy).ShakeView(0.80, 2002, 0);
			}
		}
		bShaking = False;
		GotoState('Attacking');
	}

	function KeepShakingPlayer()
	{
	local vector newlocation;

		if (PlayerPawn(Enemy) != None) { PlayerPawn(Enemy).ShakeView(1.0, 2000, -20); }
		Enemy.Acceleration = vect(0,0,0);
		Enemy.SetPhysics(PHYS_None);
		if (!bShaking)
		{ 
			newlocation=enemy.location; //lift player
			newlocation.z += 16;
			enemy.SetLocation(newlocation);
		}
		bShaking = True;
		PlaySound(sound'ZombieMoan', SLOT_Talk,,true);
		PlaySound(sound'ZombieMoan', SLOT_Interact,,true);
	}

Begin:
  if (!Region.Zone.bWaterZone) { Acceleration = vect(0,0,0); }
  TweenAnim('Shake',1);
  LoopAnim('Shake');
  bShaking = False;

KeepShaking:
  KeepShakingPlayer();
  if ((PlayerPawn(Enemy) != None) && (Enemy.Health <= 10)) { Enemy.SetPhysics(PHYS_Falling); PlayerPawn(Enemy).ShakeView(0, 2002, 0); }
  Enemy.TakeDamage((Enemy.Health * 0.12) + 6, self, Enemy.location, vect(0,0,0),'jolted');
  PHtmp = Enemy.Health;
  sleep(1.5);
  if (Enemy.Health > 0)
  {
	if ((ScriptedPawn(Enemy) != None) || (PHtmp < Enemy.Health))
		{ Enemy.TakeDamage((Enemy.Health * 0.15) + 15, self, Enemy.location, vect(0,0,0),'jolted'); }
	if ((VSize(Location - Enemy.Location) > MeleeRange + CollisionRadius + Enemy.CollisionRadius) ||
		(abs(Location.Z - Enemy.Location.Z) > 0.8 * (MeleeRange + Enemy.CollisionHeight)))
	{
	        TweenToWalking(0.3);
       		FinishAnim();
		GotoState('Charging');
  	}
	gotostate('ShakingPlayer', 'KeepShaking');
  }
  else
  { FinishAnim(); GotoState('Attacking'); }
}

state GetToPlayer
{
  ignores EnemyNotVisible;

	function SeePlayer(Actor SeenPlayer)
	{
	    if(pawn(SeenPlayer).health > 0)
		{
			if (SeenPlayer==Enemy)
			{
				if(ActorReachable(Enemy))
				{
					gotostate('Charging');
				}
				else
				{
					Enemy = None;
					Gotostate('Wandering');
				}
			}
			else
			{
				SetEnemy(Pawn(SeenPlayer));
			}
		}
	}

	function Timer()
	{
		Enable('Bump');
	}

	function Bump(Actor Other)
	{
		Super.Bump(Other);
		disable('Bump');
	}

	function SetFall()
	{
		NextState = 'GetToPlayer';
		NextLabel = 'Begin';
		NextAnim = AnimSequence;
		GotoState('FallingState');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			GotoState('GetToPlayer', 'Moving');
		}
		Focus = Destination;
		if (PickWallAdjust())
			GotoState('GetToPlayer', 'AdjustFromWall');
		else
		  Gotostate('Attacking');
	}

	function BeginState()
	{
		setTimer(2, true);
	}

	function EndState()
	{
	}

Begin:
	Acceleration = vect(0,0,0); //stop
	TweenToWalking(0.5);
	NextAnim = '';
	WaitForLanding();
	FinishAnim();

Moving:
	PlayWalking();
	MoveToward(MoveTarget, WalkingSpeed);

ContinueGetTo:
	sleep(3);
	Goto('Moving');

AdjustFromWall:
	bCanStrafe = true;
	StrafeTo(Destination, Focus);
	bCanStrafe = false;
	Destination = Focus;
	Goto('Moving');
}

state Wandering
{
	ignores EnemyNotVisible;

  function SeePlayer(Actor SeenPlayer)
  {
    	if (pawn(SeenPlayer).health > 0)
	{
			SetEnemy(Pawn(SeenPlayer));
			if (Enemy != None) { gotostate('Attacking'); }
	}
  }

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			GotoState('Wandering', 'Moving');
		}
		Focus = Destination;
		if (PickWallAdjust())
			GotoState('Wandering', 'AdjustFromWall');
		else
			GotoState('Wandering', 'Wander');
	}


	function SetFall()
	{
		NextState = 'Wandering';
		NextLabel = 'ContinueWander';
		NextAnim = AnimSequence;
		GotoState('FallingState');
	}

	function bool TestDirection(vector dir, out vector pick)
	{
		local vector HitLocation, HitNormal, dist;
		local float minDist;
		local actor HitActor;

		minDist = ( (FRand()*4)+2 )*CollisionRadius;
		pick = dir * (minDist + (450 + 12 * CollisionRadius) * FRand());
		HitActor = Trace(HitLocation, HitNormal, Location + pick + 1.5 * CollisionRadius * dir , Location, false);
		if (HitActor != None)
		{
			pick = HitLocation + (HitNormal - dir) * 2 * CollisionRadius;
			HitActor = Trace(HitLocation, HitNormal, pick , Location, false);
			if (HitActor != None)
					return false;
		}
		else
			pick = Location + pick;
		dist = pick - Location;
		if (Physics == PHYS_Walking)
			dist.Z = 0;
		return (VSize(dist) > minDist);
	}

	function PickDestination()
	{
		local vector pick, pickdir;
		local bool success;
		local float XY;

		XY = FRand();
		if (XY < 0.3)
		{
			pickdir.X = 1;
			pickdir.Y = 0;
		}
		else if (XY < 0.6)
		{
			pickdir.X = 0;
			pickdir.Y = 1;
		}
		else
		{
			pickdir.X = 2 * FRand() - 1;
			pickdir.Y = 2 * FRand() - 1;
		}
		if (Physics != PHYS_Walking)
		{
			pickdir.Z = 2 * FRand() - 1;
			pickdir = Normal(pickdir);
		}
		else
		{
			pickdir.Z = 0;
			if (XY >= 0.6)
					pickdir = Normal(pickdir);
		}
		success = TestDirection(pickdir, pick);
		if (!success)
			success = TestDirection(-1 * pickdir, pick);

		if (success)
			Destination = pick;
		else
			GotoState('Wandering', 'Turn');
	}

	function BeginState()
	{
	}

	function EndState()
	{
	}

Begin:
Wander:
	TweenToWalking(1.5);
	WaitForLanding();
	PickDestination();

Moving:
	FinishAnim();
	PlayWalking();
	Enable('HitWall');
	MoveTo(Destination, WalkingSpeed);
	FinishAnim();
	sleep(3);

ContinueWander:
	PlayWalking();
	if (FRand() < 0.2)
		Goto('Turn');
	Goto('Wander');

Turn:
	Acceleration = vect(0,0,0);
	PlayTurning();
	TurnTo(Location + 20 * VRand());
	Goto('ContinueWander');

AdjustFromWall:
	bCanStrafe = true;
	StrafeTo(Destination, Focus);
	bCanStrafe = false;
	Destination = Focus;
	Goto('Moving');

}

state TakeHit
{
	ignores seeplayer, hearnoise, bump, hitwall;

	function EndState()
	{
	}

	function PlayHitAnim(vector HitLocation, float Damage)
	{
		if (LastPainTime - Level.TimeSeconds > 0.1)
		{
			PlayTakeHit(0.1, hitLocation, Damage);
			BeginState();
			GotoState('TakeHit', 'Begin');
		}
	}

	function BeginState()
	{
		LastPainTime = Level.TimeSeconds;
		LastPainAnim = AnimSequence;
	}

Begin:
	FinishAnim();
	if ((Physics == PHYS_Falling) && !Region.Zone.bWaterZone)
	{
		Acceleration = vect(0,0,0);
		NextAnim = '';
		GotoState('FallingState', 'Ducking');
	}
	else
		GotoState('Attacking');
}

state Charging
{
ignores HearNoise;

  function SeePlayer(Actor SeenPlayer)
  {
	if ((SeenPlayer != Enemy) && (pawn(SeenPlayer).health > 0))
	{
	   if ((Location Dot SeenPlayer.Location) < (Location Dot Enemy.Location))
		{
			SetEnemy(Pawn(SeenPlayer));
		}
	}
  }

	function MayFall()
	{

		gotostate('GetToPlayer');
	}

	function EnemyNotVisible()
	{
		gotostate('GetToPlayer');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		if ( Wall.IsA('Mover') && Mover(Wall).HandleDoor(self) )
		{
			GotoState('Charging', 'Moving');
		}
		Focus = Destination;
		if (PickWallAdjust())
			GotoState('Charging', 'AdjustFromWall');
		else
			MoveTimer = -1.0;
	}

	function SetFall()
	{
		NextState = 'Charging';
		NextLabel = 'ResumeCharge';
		NextAnim = AnimSequence;
		GotoState('FallingState');
	}

	function BeginState()
	{
	}

	function EndState()
	{
	}

AdjustFromWall:
	bCanStrafe = true;
	StrafeTo(Destination, Focus);
	bCanStrafe = false;
	Goto('CloseIn');

ResumeCharge:
	PlayWalking();
	Goto('Charge');

Begin:
	TweenToWalking(1.5);
	PlayWalking();

Charge:
	bFromWall = false;

CloseIn:
	enable('bump');
  if ((Enemy == None) || (Enemy.Health <=0))
		GotoState('Wandering');

	if (Physics == PHYS_Falling)
	{
		DesiredRotation = Rotator(Enemy.Location - Location);
		Focus = Enemy.Location;
		Destination = Enemy.Location;
		WaitForLanding();
	}
	MoveToward(Enemy, WalkingSpeed);
	if (bFromWall)
	{
		bFromWall = false;
		if (PickWallAdjust()) //if can't jump obstacle
		{
			bCanStrafe = true;
			StrafeTo(Destination, Focus);
			bCanStrafe = false;
		}
		else
			GotoState('GetToPlayer');
	}
	else
	{
NoReach:
		bFromWall = false;
		if (!FindBestPathToward(Enemy))
		{
			Sleep(0.01);
			GotoState('GetToPlayer');
		}

Moving:
		if (NeedToTurn(Enemy.Location))
		{
			Acceleration = vect(0,0,0);
			TurnToward(Enemy);
			PlayWalking();
		}
		MoveToward(Enemy, WalkingSpeed);
	}
	if (VSize(Location - Enemy.Location) < CollisionRadius + Enemy.CollisionRadius + MeleeRange)
		Goto('GotThere');

	sleep(1.5);
	bFromWall = false;
	Goto('CloseIn'); //loop

GotThere:
	GotoState('MeleeAttack');
}

defaultproperties
{
    bIsKillGoal=False
    bAvoidLedges=False
    bStopAtLedges=False
    MeleeRange=30.00
    GroundSpeed=50.00
    WaterSpeed=80.00
    AccelRate=850.00
    JumpZ=120.00
    Visibility=0
    SightRadius=8200.00
//    SightRadius=4100.00
    PeripheralVision=-5.00
    BaseEyeHeight=23.00
    EyeHeight=23.00
    Health=100
    UnderWaterTime=30.00
    CombatStyle=0.85
    DrawScale=0.85
    ScaleGlow=0.70
    CollisionRadius=17.00
    CollisionHeight=39.00
    Mass=200.00
    Buoyancy=180.00
    RotationRate=(Pitch=3072,Yaw=20000,Roll=6000)
    MenuName=Zombie
}
